#!/usr/bin/perl

# Z88DK Z80 Macro Assembler
#
# Copyright (C) Paulo Custodio, 2011-2020
# License: The Artistic License 2.0, http://www.perlfoundation.org/artistic_license_2_0
# Repository: https://github.com/z88dk/z88dk/
#
# Test -debug info in map file

use Modern::Perl;
use Test::More;
require './t/testlib.pl';

# only ASM code
spew("test1.asm", <<END);
	public func

	c_line 1, "test1.c"
func:
	ld a, 1
	ld b, 3
	
	c_line 2
	add a, b
	ret
END

spew("test.asm", <<END);
	extern func

main:
	call func
	ret
END

run("z80asm -b -m test.asm test1.asm");
check_text_file("test.map", <<'END');
main                            = $0000 ; addr, local, , test, , test.asm:3
func                            = $0004 ; addr, public, , test1, , test1.c:1
__head                          = $0000 ; const, public, def, , ,
__tail                          = $000A ; const, public, def, , ,
__size                          = $000A ; const, public, def, , ,
END

run("z80asm -b -debug test.asm test1.asm");
check_text_file("test.map", <<'END');
main                            = $0000 ; addr, local, , test, , test.asm:3
__ASM_LINE_3                    = $0000 ; addr, local, , test, , test.asm:3
__ASM_LINE_4                    = $0000 ; addr, local, , test, , test.asm:4
__ASM_LINE_5                    = $0003 ; addr, local, , test, , test.asm:5
__C_LINE_1                      = $0004 ; addr, local, , test1, , test1.c:1
__C_LINE_2                      = $0008 ; addr, local, , test1, , test1.c:2
func                            = $0004 ; addr, public, , test1, , test1.c:1
__head                          = $0000 ; const, public, def, , ,
__tail                          = $000A ; const, public, def, , ,
__size                          = $000A ; const, public, def, , ,
END


# ASM and C code
unlink_testfiles();
spew("test1.asm", <<END);
	public _one
_one:
	ld hl, 1
	ret
END

spew("test.c", <<END);
extern int one();

int main() {
	return one()+one();
}
END

SKIP: {
	skip "need zcc changed", 1;
	
run("zcc +z80 -m -Ca-debug test.c test1.asm -otest.bin", 0, 'IGNORE', "");
check_text_file("test.map", <<'END');
__SDCC_IY                       = $0001 ; const, local, , z80_crt, ,
__CRTCFG                        = $0002 ; const, local, , z80_crt, , z80_crt.asm:50
__MMAP                          = $0000 ; const, local, , z80_crt, , z80_crt.asm:56
DEF__crt_enable_trap            = $0000 ; const, local, , z80_crt, , crt_defaults.inc:35
TAR__crt_org_code               = $0000 ; const, local, , z80_crt, , crt_config.inc:116
TAR__crt_org_data               = $8000 ; const, local, , z80_crt, , crt_config.inc:117
TAR__crt_org_bss                = $FFFFFFFF ; const, local, , z80_crt, , crt_config.inc:118
TAR__crt_model                  = $0002 ; const, local, , z80_crt, , crt_config.inc:120
TAR__register_sp                = $0000 ; const, local, , z80_crt, , crt_config.inc:122
TAR__crt_stack_size             = $0200 ; const, local, , z80_crt, , crt_config.inc:123
TAR__crt_initialize_bss         = $0001 ; const, local, , z80_crt, , crt_config.inc:125
TAR__crt_include_preamble       = $0000 ; const, local, , z80_crt, , crt_config.inc:127
TAR__crt_org_vector_table       = $0000 ; const, local, , z80_crt, , crt_config.inc:129
TAR__crt_interrupt_mode         = $FFFFFFFF ; const, local, , z80_crt, , crt_config.inc:130
TAR__crt_enable_commandline     = $0000 ; const, local, , z80_crt, , crt_config.inc:132
TAR__crt_enable_restart         = $0000 ; const, local, , z80_crt, , crt_config.inc:133
TAR__crt_enable_close           = $0001 ; const, local, , z80_crt, , crt_config.inc:134
TAR__crt_enable_eidi            = $0013 ; const, local, , z80_crt, , crt_config.inc:136
TAR__crt_on_exit                = $10001 ; const, local, , z80_crt, , crt_config.inc:137
TAR__crt_enable_rst             = $0000 ; const, local, , z80_crt, , crt_config.inc:139
TAR__crt_enable_nmi             = $0000 ; const, local, , z80_crt, , crt_config.inc:140
TAR__clib_exit_stack_size       = $0000 ; const, local, , z80_crt, , crt_config.inc:144
TAR__clib_quickexit_stack_size  = $0000 ; const, local, , z80_crt, , crt_config.inc:145
TAR__clib_malloc_heap_size      = $FFFFFFFF ; const, local, , z80_crt, , crt_config.inc:147
TAR__clib_stdio_heap_size       = $0080 ; const, local, , z80_crt, , crt_config.inc:148
TAR__clib_balloc_table_size     = $0000 ; const, local, , z80_crt, , crt_config.inc:150
TAR__clib_fopen_max             = $0000 ; const, local, , z80_crt, , crt_config.inc:152
TAR__clib_open_max              = $0000 ; const, local, , z80_crt, , crt_config.inc:153
__crt_org_code                  = $0000 ; const, local, , z80_crt, , z80_crt.asm:93
__register_sp                   = $0000 ; const, local, , z80_crt, , z80_crt.asm:117
__crt_stack_size                = $0200 ; const, local, , z80_crt, , z80_crt.asm:138
__crt_org_data                  = $8000 ; const, local, , z80_crt, , z80_crt.asm:157
__crt_org_bss                   = $FFFFFFFF ; const, local, , z80_crt, , z80_crt.asm:176
__crt_model                     = $0002 ; const, local, , z80_crt, , z80_crt.asm:195
__crt_initialize_bss            = $0001 ; const, local, , z80_crt, , z80_crt.asm:213
__crt_include_preamble          = $0000 ; const, local, , z80_crt, , z80_crt.asm:232
__crt_org_vector_table          = $0000 ; const, local, , z80_crt, , z80_crt.asm:250
__crt_interrupt_mode            = $FFFFFFFF ; const, local, , z80_crt, , z80_crt.asm:290
__crt_enable_commandline        = $0000 ; const, local, , z80_crt, , z80_crt.asm:309
__crt_enable_restart            = $0000 ; const, local, , z80_crt, , z80_crt.asm:328
__crt_enable_close              = $0001 ; const, local, , z80_crt, , z80_crt.asm:347
__crt_enable_eidi               = $0013 ; const, local, , z80_crt, , z80_crt.asm:366
__crt_on_exit                   = $10001 ; const, local, , z80_crt, , z80_crt.asm:391
__clib_exit_stack_size          = $0000 ; const, local, , z80_crt, , z80_crt.asm:412
__clib_quickexit_stack_size     = $0000 ; const, local, , z80_crt, , z80_crt.asm:431
__clib_malloc_heap_size         = $FFFFFFFF ; const, local, , z80_crt, , z80_crt.asm:450
__clib_stdio_heap_size          = $0080 ; const, local, , z80_crt, , z80_crt.asm:469
__clib_balloc_table_size        = $0000 ; const, local, , z80_crt, , z80_crt.asm:488
__crt_enable_rst                = $0000 ; const, local, , z80_crt, , z80_crt.asm:545
__crt_enable_nmi                = $0000 ; const, local, , z80_crt, , z80_crt.asm:564
__ASM_LINE_7                    = $0177 ; addr, local, , z80_crt, rodata_error_string_end, c:/Users/paulo/git/z88dk/lib/config\..\..\/libsrc/_DEVELOPMENT/target/z80/../../clib_rodata.inc:7
__ASM_LINE_797                  = $808B ; addr, local, , z80_crt, bss_stdio, z80_crt.asm:797
__ASM_LINE_803                  = $8004 ; addr, local, , z80_crt, data_stdio, z80_crt.asm:803
__ASM_LINE_942                  = $8002 ; addr, local, , z80_crt, data_fcntl, z80_crt.asm:942
__ASM_LINE_949                  = $800B ; addr, local, , z80_crt, bss_fcntl, z80_crt.asm:949
__ASM_LINE_953                  = $0086 ; addr, local, , z80_crt, code_crt_init, z80_crt.asm:953
__ASM_LINE_954                  = $0089 ; addr, local, , z80_crt, code_crt_init, z80_crt.asm:954
__ASM_LINE_957                  = $008C ; addr, local, , z80_crt, code_crt_init, z80_crt.asm:957
__ASM_LINE_3                    = $0000 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:3
__ASM_LINE_4                    = $0001 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:4
__ASM_LINE_5                    = $0003 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:5
__ASM_LINE_9                    = $0006 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:9
__ASM_LINE_24                   = $0008 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:24
__ASM_LINE_37                   = $000B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:37
__ASM_LINE_41                   = $0010 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:41
__ASM_LINE_56                   = $0010 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:56
__ASM_LINE_69                   = $0013 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:69
__ASM_LINE_73                   = $0018 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:73
__ASM_LINE_88                   = $0018 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:88
__ASM_LINE_103                  = $001B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:103
__ASM_LINE_104                  = $001C ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:104
__ASM_LINE_105                  = $001D ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:105
__ASM_LINE_107                  = $001E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:107
__ASM_LINE_109                  = $001E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:109
__ASM_LINE_113                  = $001F ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:113
__ASM_LINE_128                  = $0020 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:128
__ASM_LINE_143                  = $0023 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:143
__ASM_LINE_144                  = $0024 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:144
__ASM_LINE_145                  = $0025 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:145
__ASM_LINE_147                  = $0026 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:147
__ASM_LINE_149                  = $0026 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:149
__ASM_LINE_153                  = $0027 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:153
__ASM_LINE_168                  = $0028 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:168
__ASM_LINE_183                  = $002B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:183
__ASM_LINE_184                  = $002C ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:184
__ASM_LINE_185                  = $002D ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:185
__ASM_LINE_187                  = $002E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:187
__ASM_LINE_189                  = $002E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:189
__ASM_LINE_193                  = $002F ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:193
__ASM_LINE_208                  = $0030 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:208
__ASM_LINE_225                  = $0033 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:225
__ASM_LINE_227                  = $0033 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:227
__ASM_LINE_231                  = $0034 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:231
__ASM_LINE_233                  = $0034 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:233
__ASM_LINE_237                  = $0035 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:237
__ASM_LINE_239                  = $0035 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:239
__ASM_LINE_266                  = $0037 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:266
__ASM_LINE_282                  = $0038 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:282
__ASM_LINE_297                  = $003B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:297
__ASM_LINE_298                  = $003C ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:298
__ASM_LINE_299                  = $003D ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:299
__ASM_LINE_300                  = $003E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:300
__ASM_LINE_301                  = $003F ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:301
__ASM_LINE_302                  = $0040 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:302
__ASM_LINE_303                  = $0041 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:303
__ASM_LINE_304                  = $0042 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:304
__ASM_LINE_306                  = $0043 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:306
__ASM_LINE_307                  = $0044 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:307
__ASM_LINE_308                  = $0045 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:308
__ASM_LINE_309                  = $0046 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:309
__ASM_LINE_310                  = $0047 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:310
__ASM_LINE_311                  = $0048 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:311
__ASM_LINE_312                  = $0049 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:312
__ASM_LINE_313                  = $004A ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:313
__ASM_LINE_315                  = $004B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:315
__ASM_LINE_316                  = $004C ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:316
__ASM_LINE_317                  = $004D ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:317
__ASM_LINE_318                  = $004E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:318
__ASM_LINE_319                  = $004F ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:319
__ASM_LINE_320                  = $0050 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:320
__ASM_LINE_321                  = $0051 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:321
__ASM_LINE_322                  = $0052 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:322
__ASM_LINE_324                  = $0053 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:324
__ASM_LINE_325                  = $0054 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:325
__ASM_LINE_326                  = $0055 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:326
__ASM_LINE_327                  = $0056 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:327
__ASM_LINE_328                  = $0057 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:328
__ASM_LINE_329                  = $0058 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:329
__ASM_LINE_330                  = $0059 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:330
__ASM_LINE_331                  = $005A ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:331
__ASM_LINE_333                  = $005B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:333
__ASM_LINE_335                  = $005B ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:335
__ASM_LINE_339                  = $005C ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:339
__ASM_LINE_340                  = $005D ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:340
__ASM_LINE_342                  = $005E ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:342
__ASM_LINE_343                  = $005F ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:343
__ASM_LINE_345                  = $0060 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:345
__ASM_LINE_346                  = $0061 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:346
__ASM_LINE_348                  = $0062 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:348
__ASM_LINE_349                  = $0063 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:349
__ASM_LINE_351                  = $0064 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:351
__ASM_LINE_353                  = $0064 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:353
__ASM_LINE_357                  = $0065 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:357
__ASM_LINE_373                  = $0066 ; addr, local, , z80_crt, CODE, crt_page_zero_z80.inc:373
__page_zero_present             = $0001 ; const, local, , z80_crt, CODE, crt_page_zero_z80.inc:688
__ASM_LINE_999                  = $0069 ; addr, local, , z80_crt, CODE, z80_crt.asm:999
__Restart                       = $006A ; addr, local, , z80_crt, CODE, z80_crt.asm:1004
__ASM_LINE_1004                 = $006A ; addr, local, , z80_crt, CODE, z80_crt.asm:1004
__Restart_2                     = $006D ; addr, local, , z80_crt, CODE, z80_crt.asm:1016
__ASM_LINE_1016                 = $006D ; addr, local, , z80_crt, CODE, z80_crt.asm:1016
__ASM_LINE_27                   = $006D ; addr, local, , z80_crt, CODE, clib_init_data.inc:27
__ASM_LINE_28                   = $0070 ; addr, local, , z80_crt, CODE, clib_init_data.inc:28
__ASM_LINE_29                   = $0073 ; addr, local, , z80_crt, CODE, clib_init_data.inc:29
__ASM_LINE_31                   = $0076 ; addr, local, , z80_crt, CODE, clib_init_data.inc:31
__ASM_LINE_32                   = $0077 ; addr, local, , z80_crt, CODE, clib_init_data.inc:32
__ASM_LINE_35                   = $0078 ; addr, local, , z80_crt, CODE, clib_init_data.inc:35
__ASM_LINE_10                   = $007E ; addr, local, , z80_crt, CODE, clib_init_bss.inc:10
__ASM_LINE_12                   = $0081 ; addr, local, , z80_crt, CODE, clib_init_bss.inc:12
__ASM_LINE_13                   = $0083 ; addr, local, , z80_crt, CODE, clib_init_bss.inc:13
__ASM_LINE_1044                 = $00AF ; addr, local, , z80_crt, code_crt_main, z80_crt.asm:1044
__ASM_LINE_1055                 = $00B2 ; addr, local, , z80_crt, code_crt_main, z80_crt.asm:1055
__ASM_LINE_1061                 = $00B2 ; addr, local, , z80_crt, code_crt_main, z80_crt.asm:1061
__ASM_LINE_48                   = $00B5 ; addr, local, , z80_crt, code_crt_return, crt_program_exit.inc:48
__ASM_LINE_49                   = $00B6 ; addr, local, , z80_crt, code_crt_return, crt_program_exit.inc:49
__ASM_LINE_39                   = $008F ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:39
__ASM_LINE_40                   = $0092 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:40
__ASM_LINE_42                   = $0093 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:42
__ASM_LINE_44                   = $0096 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:44
__ASM_LINE_45                   = $0097 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:45
__ASM_LINE_47                   = $0099 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:47
__ASM_LINE_50                   = $009F ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:50
__ASM_LINE_52                   = $00A1 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:52
__ASM_LINE_54                   = $00A4 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:54
__ASM_LINE_55                   = $00A7 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:55
__ASM_LINE_57                   = $00A8 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:57
__ASM_LINE_58                   = $00A9 ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:58
__ASM_LINE_60                   = $00AA ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:60
__ASM_LINE_63                   = $00AB ; addr, local, , z80_crt, code_crt_init, clib_variables.inc:63
__ASM_LINE_136                  = $808D ; addr, local, , z80_crt, bss_stdlib, clib_variables.inc:136
__ASM_LINE_137                  = $808E ; addr, local, , z80_crt, bss_stdlib, clib_variables.inc:137
__ASM_LINE_146                  = $808E ; addr, local, , z80_crt, bss_stdlib, clib_variables.inc:146
__ASM_LINE_156                  = $8008 ; addr, local, , z80_crt, data_threads, clib_variables.inc:156
__ASM_LINE_230                  = $016C ; addr, local, , test_c, code_compiler, test.c:230
__ASM_LINE_231                  = $016C ; addr, local, , test_c, code_compiler, test.c:231
__ASM_LINE_232                  = $016F ; addr, local, , test_c, code_compiler, test.c:232
__ASM_LINE_233                  = $0170 ; addr, local, , test_c, code_compiler, test.c:233
__ASM_LINE_234                  = $0173 ; addr, local, , test_c, code_compiler, test.c:234
__ASM_LINE_235                  = $0174 ; addr, local, , test_c, code_compiler, test.c:235
__ASM_LINE_236                  = $0175 ; addr, local, , test_c, code_compiler, test.c:236
__ASM_LINE_237                  = $0176 ; addr, local, , test_c, code_compiler, test.c:237
__ASM_LINE_4                    = $0000 ; addr, local, , test1, , test1.asm:4
__ASM_LINE_5                    = $0000 ; addr, local, , test1, , test1.asm:5
__ASM_LINE_6                    = $0003 ; addr, local, , test1, , test1.asm:6
__CPU_INFO                      = $0000 ; const, local, , asm_dzx7_standard, , config_private.inc:55
dzx7s_copy_byte_loop            = $00DC ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:33
dzx7s_main_loop                 = $00DE ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:37
dzx7s_next_bit                  = $011B ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:111
dzx7s_len_size_loop             = $00E8 ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:48
dzx7s_len_value_loop            = $00EE ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:56
dzx7s_offset_end                = $010F ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:94
dzx7s_rld_next_bit              = $0105 ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:86
dzx7s_exit                      = $0118 ; addr, local, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:106
__CLIB_OPT_ERROR                = $0000 ; const, local, , error_enolck_zc, , config_private.inc:261
__CLIB_OPT_UNROLL               = $0000 ; const, local, , asm_memset, , config_private.inc:232
__CLIB_OPT_UNROLL_MEMSET        = $0002 ; const, local, , asm_memset, , config_private.inc:235
unknown_type                    = $0167 ; addr, local, , asm_mtx_init, code_threads_mutex, threads/mutex/z80/asm_mtx_init.asm:60
__Z88DK                         = $07C8 ; const, public, , z80_crt, , config_z80_public.inc:24
__EMBEDDED_Z80                  = $0001 ; const, public, , z80_crt, , config_z80_public.inc:39
__Z80                           = $0001 ; const, public, , z80_crt, , config_z80_public.inc:63
__Z80_NMOS                      = $0001 ; const, public, , z80_crt, , config_z80_public.inc:65
__Z80_CMOS                      = $0002 ; const, public, , z80_crt, , config_z80_public.inc:66
__CPU_CLOCK                     = $3D0900 ; const, public, , z80_crt, , config_z80_public.inc:68
__CPU_INFO                      = $0000 ; const, public, , z80_crt, , config_z80_public.inc:70
__CPU_INFO_ENABLE_SLL           = $0001 ; const, public, , z80_crt, , config_z80_public.inc:72
__CLIB_OPT_MULTITHREAD          = $0000 ; const, public, , z80_crt, , config_z80_public.inc:281
__CLIB_OPT_MULTITHREAD_LOCK_HEAPS = $0001 ; const, public, , z80_crt, , config_z80_public.inc:283
__CLIB_OPT_MULTITHREAD_LOCK_FILES = $0002 ; const, public, , z80_crt, , config_z80_public.inc:284
__CLIB_OPT_MULTITHREAD_LOCK_FLIST = $0004 ; const, public, , z80_crt, , config_z80_public.inc:285
__CLIB_OPT_MULTITHREAD_LOCK_FDTBL = $0008 ; const, public, , z80_crt, , config_z80_public.inc:286
__CLIB_OPT_MULTITHREAD_LOCK_FDSTR = $0010 ; const, public, , z80_crt, , config_z80_public.inc:287
__CLIB_OPT_IMATH                = $0000 ; const, public, , z80_crt, , config_z80_public.inc:289
__CLIB_OPT_IMATH_FAST           = $000F ; const, public, , z80_crt, , config_z80_public.inc:291
__CLIB_OPT_IMATH_FAST_DIV_UNROLL = $0001 ; const, public, , z80_crt, , config_z80_public.inc:293
__CLIB_OPT_IMATH_FAST_DIV_LZEROS = $0002 ; const, public, , z80_crt, , config_z80_public.inc:294
__CLIB_OPT_IMATH_FAST_MUL_UNROLL = $0004 ; const, public, , z80_crt, , config_z80_public.inc:295
__CLIB_OPT_IMATH_FAST_MUL_LZEROS = $0008 ; const, public, , z80_crt, , config_z80_public.inc:296
__CLIB_OPT_IMATH_FAST_LIA       = $0080 ; const, public, , z80_crt, , config_z80_public.inc:297
__CLIB_OPT_IMATH_SELECT         = $0000 ; const, public, , z80_crt, , config_z80_public.inc:299
__CLIB_OPT_IMATH_SELECT_FAST_ASR = $0001 ; const, public, , z80_crt, , config_z80_public.inc:301
__CLIB_OPT_IMATH_SELECT_FAST_LSR = $0002 ; const, public, , z80_crt, , config_z80_public.inc:302
__CLIB_OPT_IMATH_SELECT_FAST_LSL = $0004 ; const, public, , z80_crt, , config_z80_public.inc:303
__CLIB_OPT_TXT2NUM              = $0004 ; const, public, , z80_crt, , config_z80_public.inc:305
__CLIB_OPT_TXT2NUM_INT_BIN      = $0001 ; const, public, , z80_crt, , config_z80_public.inc:307
__CLIB_OPT_TXT2NUM_INT_OCT      = $0002 ; const, public, , z80_crt, , config_z80_public.inc:308
__CLIB_OPT_TXT2NUM_INT_DEC      = $0004 ; const, public, , z80_crt, , config_z80_public.inc:309
__CLIB_OPT_TXT2NUM_INT_HEX      = $0008 ; const, public, , z80_crt, , config_z80_public.inc:310
__CLIB_OPT_TXT2NUM_LONG_BIN     = $0010 ; const, public, , z80_crt, , config_z80_public.inc:312
__CLIB_OPT_TXT2NUM_LONG_OCT     = $0020 ; const, public, , z80_crt, , config_z80_public.inc:313
__CLIB_OPT_TXT2NUM_LONG_DEC     = $0040 ; const, public, , z80_crt, , config_z80_public.inc:314
__CLIB_OPT_TXT2NUM_LONG_HEX     = $0080 ; const, public, , z80_crt, , config_z80_public.inc:315
__CLIB_OPT_TXT2NUM_SELECT       = $0000 ; const, public, , z80_crt, , config_z80_public.inc:317
__CLIB_OPT_TXT2NUM_SELECT_FAST_BIN = $0001 ; const, public, , z80_crt, , config_z80_public.inc:319
__CLIB_OPT_TXT2NUM_SELECT_FAST_OCT = $0002 ; const, public, , z80_crt, , config_z80_public.inc:320
__CLIB_OPT_TXT2NUM_SELECT_FAST_DEC = $0004 ; const, public, , z80_crt, , config_z80_public.inc:321
__CLIB_OPT_TXT2NUM_SELECT_FAST_HEX = $0008 ; const, public, , z80_crt, , config_z80_public.inc:322
__CLIB_OPT_NUM2TXT              = $0000 ; const, public, , z80_crt, , config_z80_public.inc:324
__CLIB_OPT_NUM2TXT_INT_BIN      = $0001 ; const, public, , z80_crt, , config_z80_public.inc:326
__CLIB_OPT_NUM2TXT_INT_OCT      = $0002 ; const, public, , z80_crt, , config_z80_public.inc:327
__CLIB_OPT_NUM2TXT_INT_DEC      = $0004 ; const, public, , z80_crt, , config_z80_public.inc:328
__CLIB_OPT_NUM2TXT_INT_HEX      = $0008 ; const, public, , z80_crt, , config_z80_public.inc:329
__CLIB_OPT_NUM2TXT_LONG_BIN     = $0010 ; const, public, , z80_crt, , config_z80_public.inc:331
__CLIB_OPT_NUM2TXT_LONG_OCT     = $0020 ; const, public, , z80_crt, , config_z80_public.inc:332
__CLIB_OPT_NUM2TXT_LONG_DEC     = $0040 ; const, public, , z80_crt, , config_z80_public.inc:333
__CLIB_OPT_NUM2TXT_LONG_HEX     = $0080 ; const, public, , z80_crt, , config_z80_public.inc:334
__CLIB_OPT_NUM2TXT_SELECT       = $0000 ; const, public, , z80_crt, , config_z80_public.inc:336
__CLIB_OPT_NUM2TXT_SELECT_FAST_BIN = $0001 ; const, public, , z80_crt, , config_z80_public.inc:338
__CLIB_OPT_NUM2TXT_SELECT_FAST_OCT = $0002 ; const, public, , z80_crt, , config_z80_public.inc:339
__CLIB_OPT_NUM2TXT_SELECT_FAST_DEC = $0004 ; const, public, , z80_crt, , config_z80_public.inc:340
__CLIB_OPT_NUM2TXT_SELECT_FAST_HEX = $0008 ; const, public, , z80_crt, , config_z80_public.inc:341
__CLIB_OPT_STDIO                = $0000 ; const, public, , z80_crt, , config_z80_public.inc:343
__CLIB_OPT_STDIO_VALID          = $0001 ; const, public, , z80_crt, , config_z80_public.inc:345
CHAR_CR                         = $000D ; const, public, , z80_crt, , config_z80_public.inc:347
CHAR_LF                         = $000A ; const, public, , z80_crt, , config_z80_public.inc:348
CHAR_BS                         = $000C ; const, public, , z80_crt, , config_z80_public.inc:349
CHAR_ESC                        = $001B ; const, public, , z80_crt, , config_z80_public.inc:350
CHAR_CAPS                       = $0006 ; const, public, , z80_crt, , config_z80_public.inc:351
CHAR_BELL                       = $0007 ; const, public, , z80_crt, , config_z80_public.inc:352
CHAR_CTRL_C                     = $0003 ; const, public, , z80_crt, , config_z80_public.inc:353
CHAR_CTRL_D                     = $0004 ; const, public, , z80_crt, , config_z80_public.inc:354
CHAR_CTRL_Z                     = $001A ; const, public, , z80_crt, , config_z80_public.inc:355
CHAR_CURSOR_UC                  = $002D ; const, public, , z80_crt, , config_z80_public.inc:356
CHAR_CURSOR_LC                  = $005F ; const, public, , z80_crt, , config_z80_public.inc:357
CHAR_PASSWORD                   = $002A ; const, public, , z80_crt, , config_z80_public.inc:358
__CLIB_OPT_PRINTF               = $2FF6FF ; const, public, , z80_crt, , config_z80_public.inc:360
__CLIB_OPT_PRINTF_d             = $0001 ; const, public, , z80_crt, , config_z80_public.inc:362
__CLIB_OPT_PRINTF_u             = $0002 ; const, public, , z80_crt, , config_z80_public.inc:363
__CLIB_OPT_PRINTF_x             = $0004 ; const, public, , z80_crt, , config_z80_public.inc:364
__CLIB_OPT_PRINTF_X             = $0008 ; const, public, , z80_crt, , config_z80_public.inc:365
__CLIB_OPT_PRINTF_o             = $0010 ; const, public, , z80_crt, , config_z80_public.inc:366
__CLIB_OPT_PRINTF_n             = $0020 ; const, public, , z80_crt, , config_z80_public.inc:367
__CLIB_OPT_PRINTF_i             = $0040 ; const, public, , z80_crt, , config_z80_public.inc:368
__CLIB_OPT_PRINTF_p             = $0080 ; const, public, , z80_crt, , config_z80_public.inc:369
__CLIB_OPT_PRINTF_B             = $0100 ; const, public, , z80_crt, , config_z80_public.inc:370
__CLIB_OPT_PRINTF_s             = $0200 ; const, public, , z80_crt, , config_z80_public.inc:371
__CLIB_OPT_PRINTF_c             = $0400 ; const, public, , z80_crt, , config_z80_public.inc:372
__CLIB_OPT_PRINTF_I             = $0800 ; const, public, , z80_crt, , config_z80_public.inc:373
__CLIB_OPT_PRINTF_ld            = $1000 ; const, public, , z80_crt, , config_z80_public.inc:374
__CLIB_OPT_PRINTF_lu            = $2000 ; const, public, , z80_crt, , config_z80_public.inc:375
__CLIB_OPT_PRINTF_lx            = $4000 ; const, public, , z80_crt, , config_z80_public.inc:376
__CLIB_OPT_PRINTF_lX            = $8000 ; const, public, , z80_crt, , config_z80_public.inc:377
__CLIB_OPT_PRINTF_lo            = $10000 ; const, public, , z80_crt, , config_z80_public.inc:378
__CLIB_OPT_PRINTF_ln            = $20000 ; const, public, , z80_crt, , config_z80_public.inc:379
__CLIB_OPT_PRINTF_li            = $40000 ; const, public, , z80_crt, , config_z80_public.inc:380
__CLIB_OPT_PRINTF_lp            = $80000 ; const, public, , z80_crt, , config_z80_public.inc:381
__CLIB_OPT_PRINTF_lB            = $100000 ; const, public, , z80_crt, , config_z80_public.inc:382
__CLIB_OPT_PRINTF_a             = $400000 ; const, public, , z80_crt, , config_z80_public.inc:383
__CLIB_OPT_PRINTF_A             = $800000 ; const, public, , z80_crt, , config_z80_public.inc:384
__CLIB_OPT_PRINTF_e             = $1000000 ; const, public, , z80_crt, , config_z80_public.inc:385
__CLIB_OPT_PRINTF_E             = $2000000 ; const, public, , z80_crt, , config_z80_public.inc:386
__CLIB_OPT_PRINTF_f             = $4000000 ; const, public, , z80_crt, , config_z80_public.inc:387
__CLIB_OPT_PRINTF_F             = $8000000 ; const, public, , z80_crt, , config_z80_public.inc:388
__CLIB_OPT_PRINTF_g             = $10000000 ; const, public, , z80_crt, , config_z80_public.inc:389
__CLIB_OPT_PRINTF_G             = $20000000 ; const, public, , z80_crt, , config_z80_public.inc:390
__CLIB_OPT_PRINTF_2             = $0000 ; const, public, , z80_crt, , config_z80_public.inc:392
__CLIB_OPT_PRINTF_2_lld         = $0001 ; const, public, , z80_crt, , config_z80_public.inc:394
__CLIB_OPT_PRINTF_2_llu         = $0002 ; const, public, , z80_crt, , config_z80_public.inc:395
__CLIB_OPT_PRINTF_2_llx         = $0004 ; const, public, , z80_crt, , config_z80_public.inc:396
__CLIB_OPT_PRINTF_2_llX         = $0008 ; const, public, , z80_crt, , config_z80_public.inc:397
__CLIB_OPT_PRINTF_2_llo         = $0010 ; const, public, , z80_crt, , config_z80_public.inc:398
__CLIB_OPT_PRINTF_2_lli         = $0040 ; const, public, , z80_crt, , config_z80_public.inc:399
__CLIB_OPT_SCANF                = $2FF6FF ; const, public, , z80_crt, , config_z80_public.inc:401
__CLIB_OPT_SCANF_d              = $0001 ; const, public, , z80_crt, , config_z80_public.inc:403
__CLIB_OPT_SCANF_u              = $0002 ; const, public, , z80_crt, , config_z80_public.inc:404
__CLIB_OPT_SCANF_x              = $0004 ; const, public, , z80_crt, , config_z80_public.inc:405
__CLIB_OPT_SCANF_X              = $0008 ; const, public, , z80_crt, , config_z80_public.inc:406
__CLIB_OPT_SCANF_o              = $0010 ; const, public, , z80_crt, , config_z80_public.inc:407
__CLIB_OPT_SCANF_n              = $0020 ; const, public, , z80_crt, , config_z80_public.inc:408
__CLIB_OPT_SCANF_i              = $0040 ; const, public, , z80_crt, , config_z80_public.inc:409
__CLIB_OPT_SCANF_p              = $0080 ; const, public, , z80_crt, , config_z80_public.inc:410
__CLIB_OPT_SCANF_B              = $0100 ; const, public, , z80_crt, , config_z80_public.inc:411
__CLIB_OPT_SCANF_s              = $0200 ; const, public, , z80_crt, , config_z80_public.inc:412
__CLIB_OPT_SCANF_c              = $0400 ; const, public, , z80_crt, , config_z80_public.inc:413
__CLIB_OPT_SCANF_I              = $0800 ; const, public, , z80_crt, , config_z80_public.inc:414
__CLIB_OPT_SCANF_ld             = $1000 ; const, public, , z80_crt, , config_z80_public.inc:415
__CLIB_OPT_SCANF_lu             = $2000 ; const, public, , z80_crt, , config_z80_public.inc:416
__CLIB_OPT_SCANF_lx             = $4000 ; const, public, , z80_crt, , config_z80_public.inc:417
__CLIB_OPT_SCANF_lX             = $8000 ; const, public, , z80_crt, , config_z80_public.inc:418
__CLIB_OPT_SCANF_lo             = $10000 ; const, public, , z80_crt, , config_z80_public.inc:419
__CLIB_OPT_SCANF_ln             = $20000 ; const, public, , z80_crt, , config_z80_public.inc:420
__CLIB_OPT_SCANF_li             = $40000 ; const, public, , z80_crt, , config_z80_public.inc:421
__CLIB_OPT_SCANF_lp             = $80000 ; const, public, , z80_crt, , config_z80_public.inc:422
__CLIB_OPT_SCANF_lB             = $100000 ; const, public, , z80_crt, , config_z80_public.inc:423
__CLIB_OPT_SCANF_BRACKET        = $200000 ; const, public, , z80_crt, , config_z80_public.inc:424
__CLIB_OPT_SCANF_a              = $400000 ; const, public, , z80_crt, , config_z80_public.inc:425
__CLIB_OPT_SCANF_A              = $800000 ; const, public, , z80_crt, , config_z80_public.inc:426
__CLIB_OPT_SCANF_e              = $1000000 ; const, public, , z80_crt, , config_z80_public.inc:427
__CLIB_OPT_SCANF_E              = $2000000 ; const, public, , z80_crt, , config_z80_public.inc:428
__CLIB_OPT_SCANF_f              = $4000000 ; const, public, , z80_crt, , config_z80_public.inc:429
__CLIB_OPT_SCANF_F              = $8000000 ; const, public, , z80_crt, , config_z80_public.inc:430
__CLIB_OPT_SCANF_g              = $10000000 ; const, public, , z80_crt, , config_z80_public.inc:431
__CLIB_OPT_SCANF_G              = $20000000 ; const, public, , z80_crt, , config_z80_public.inc:432
__CLIB_OPT_SCANF_2              = $0000 ; const, public, , z80_crt, , config_z80_public.inc:434
__CLIB_OPT_SCANF_2_lld          = $0001 ; const, public, , z80_crt, , config_z80_public.inc:436
__CLIB_OPT_SCANF_2_llu          = $0002 ; const, public, , z80_crt, , config_z80_public.inc:437
__CLIB_OPT_SCANF_2_llx          = $0004 ; const, public, , z80_crt, , config_z80_public.inc:438
__CLIB_OPT_SCANF_2_llX          = $0008 ; const, public, , z80_crt, , config_z80_public.inc:439
__CLIB_OPT_SCANF_2_llo          = $0010 ; const, public, , z80_crt, , config_z80_public.inc:440
__CLIB_OPT_SCANF_2_lli          = $0040 ; const, public, , z80_crt, , config_z80_public.inc:441
__CLIB_OPT_UNROLL               = $0000 ; const, public, , z80_crt, , config_z80_public.inc:443
__CLIB_OPT_UNROLL_MEMCPY        = $0001 ; const, public, , z80_crt, , config_z80_public.inc:445
__CLIB_OPT_UNROLL_MEMSET        = $0002 ; const, public, , z80_crt, , config_z80_public.inc:446
__CLIB_OPT_UNROLL_OTIR          = $0010 ; const, public, , z80_crt, , config_z80_public.inc:447
__CLIB_OPT_UNROLL_LDIR          = $0020 ; const, public, , z80_crt, , config_z80_public.inc:448
__CLIB_OPT_UNROLL_USER_SMC      = $0040 ; const, public, , z80_crt, , config_z80_public.inc:449
__CLIB_OPT_UNROLL_LIB_SMC       = $0080 ; const, public, , z80_crt, , config_z80_public.inc:450
__CLIB_OPT_STRTOD               = $0000 ; const, public, , z80_crt, , config_z80_public.inc:452
__CLIB_OPT_STRTOD_NAN           = $0001 ; const, public, , z80_crt, , config_z80_public.inc:454
__CLIB_OPT_STRTOD_INF           = $0001 ; const, public, , z80_crt, , config_z80_public.inc:455
__CLIB_OPT_STRTOD_HEX           = $0002 ; const, public, , z80_crt, , config_z80_public.inc:456
__CLIB_OPT_SORT                 = $0001 ; const, public, , z80_crt, , config_z80_public.inc:458
__CLIB_OPT_SORT_INSERTION       = $0000 ; const, public, , z80_crt, , config_z80_public.inc:460
__CLIB_OPT_SORT_SHELL           = $0001 ; const, public, , z80_crt, , config_z80_public.inc:461
__CLIB_OPT_SORT_QUICK           = $0002 ; const, public, , z80_crt, , config_z80_public.inc:462
__CLIB_OPT_SORT_QSORT           = $000C ; const, public, , z80_crt, , config_z80_public.inc:464
__CLIB_OPT_SORT_QSORT_PIVOT     = $0003 ; const, public, , z80_crt, , config_z80_public.inc:466
__CLIB_OPT_SORT_QSORT_PIVOT_MID = $0000 ; const, public, , z80_crt, , config_z80_public.inc:467
__CLIB_OPT_SORT_QSORT_PIVOT_RAN = $0001 ; const, public, , z80_crt, , config_z80_public.inc:468
__CLIB_OPT_SORT_QSORT_ENABLE_INSERTION = $0004 ; const, public, , z80_crt, , config_z80_public.inc:469
__CLIB_OPT_SORT_QSORT_ENABLE_EQUAL = $0008 ; const, public, , z80_crt, , config_z80_public.inc:470
__CLIB_OPT_ERROR                = $0000 ; const, public, , z80_crt, , config_z80_public.inc:472
__CLIB_OPT_ERROR_ENABLED        = $0001 ; const, public, , z80_crt, , config_z80_public.inc:474
__CLIB_OPT_ERROR_VERBOSE        = $0002 ; const, public, , z80_crt, , config_z80_public.inc:475
__EOK                           = $0000 ; const, public, , z80_crt, , config_z80_public.inc:615
__EACCES                        = $0001 ; const, public, , z80_crt, , config_z80_public.inc:616
__EBADF                         = $0002 ; const, public, , z80_crt, , config_z80_public.inc:617
__EBDFD                         = $0003 ; const, public, , z80_crt, , config_z80_public.inc:618
__EDOM                          = $0004 ; const, public, , z80_crt, , config_z80_public.inc:619
__EFBIG                         = $0005 ; const, public, , z80_crt, , config_z80_public.inc:620
__EINVAL                        = $0006 ; const, public, , z80_crt, , config_z80_public.inc:621
__EMFILE                        = $0007 ; const, public, , z80_crt, , config_z80_public.inc:622
__ENFILE                        = $0008 ; const, public, , z80_crt, , config_z80_public.inc:623
__ENOLCK                        = $0009 ; const, public, , z80_crt, , config_z80_public.inc:624
__ENOMEM                        = $000A ; const, public, , z80_crt, , config_z80_public.inc:625
__ENOTSUP                       = $000B ; const, public, , z80_crt, , config_z80_public.inc:626
__EOVERFLOW                     = $000C ; const, public, , z80_crt, , config_z80_public.inc:627
__ERANGE                        = $000D ; const, public, , z80_crt, , config_z80_public.inc:628
__ESTAT                         = $000E ; const, public, , z80_crt, , config_z80_public.inc:629
__EAGAIN                        = $000F ; const, public, , z80_crt, , config_z80_public.inc:630
__EWOULDBLOCK                   = $000F ; const, public, , z80_crt, , config_z80_public.inc:631
__ERROR_NEXT                    = $0032 ; const, public, , z80_crt, , config_z80_public.inc:633
STDIO_SEEK_SET                  = $0000 ; const, public, , z80_crt, , config_z80_public.inc:635
STDIO_SEEK_CUR                  = $0001 ; const, public, , z80_crt, , config_z80_public.inc:636
STDIO_SEEK_END                  = $0002 ; const, public, , z80_crt, , config_z80_public.inc:637
STDIO_MSG_PUTC                  = $0001 ; const, public, , z80_crt, , config_z80_public.inc:639
STDIO_MSG_WRIT                  = $0002 ; const, public, , z80_crt, , config_z80_public.inc:640
STDIO_MSG_GETC                  = $0003 ; const, public, , z80_crt, , config_z80_public.inc:641
STDIO_MSG_EATC                  = $0004 ; const, public, , z80_crt, , config_z80_public.inc:642
STDIO_MSG_READ                  = $0005 ; const, public, , z80_crt, , config_z80_public.inc:643
STDIO_MSG_SEEK                  = $0006 ; const, public, , z80_crt, , config_z80_public.inc:644
STDIO_MSG_ICTL                  = $0007 ; const, public, , z80_crt, , config_z80_public.inc:645
STDIO_MSG_FLSH                  = $0008 ; const, public, , z80_crt, , config_z80_public.inc:646
STDIO_MSG_CLOS                  = $0009 ; const, public, , z80_crt, , config_z80_public.inc:647
ITERM_MSG_GETC                  = $000F ; const, public, , z80_crt, , config_z80_public.inc:649
ITERM_MSG_INTERRUPT             = $0010 ; const, public, , z80_crt, , config_z80_public.inc:650
ITERM_MSG_PUTC                  = $0011 ; const, public, , z80_crt, , config_z80_public.inc:651
ITERM_MSG_PRINT_CURSOR          = $0012 ; const, public, , z80_crt, , config_z80_public.inc:652
ITERM_MSG_ERASE_CURSOR          = $0013 ; const, public, , z80_crt, , config_z80_public.inc:653
ITERM_MSG_ERASE_CURSOR_PWD      = $0014 ; const, public, , z80_crt, , config_z80_public.inc:654
ITERM_MSG_BS                    = $0015 ; const, public, , z80_crt, , config_z80_public.inc:655
ITERM_MSG_BS_PWD                = $0016 ; const, public, , z80_crt, , config_z80_public.inc:656
ITERM_MSG_READLINE_BEGIN        = $0017 ; const, public, , z80_crt, , config_z80_public.inc:657
ITERM_MSG_READLINE_END          = $0018 ; const, public, , z80_crt, , config_z80_public.inc:658
ITERM_MSG_BELL                  = $0019 ; const, public, , z80_crt, , config_z80_public.inc:659
__MESSAGE_ITERM_NEXT__          = $001A ; const, public, , z80_crt, , config_z80_public.inc:661
OTERM_MSG_PUTC                  = $001E ; const, public, , z80_crt, , config_z80_public.inc:663
OTERM_MSG_TTY                   = $001F ; const, public, , z80_crt, , config_z80_public.inc:664
OTERM_MSG_PRINTC                = $0020 ; const, public, , z80_crt, , config_z80_public.inc:665
OTERM_MSG_SCROLL                = $0021 ; const, public, , z80_crt, , config_z80_public.inc:666
OTERM_MSG_CLS                   = $0022 ; const, public, , z80_crt, , config_z80_public.inc:667
OTERM_MSG_PAUSE                 = $0023 ; const, public, , z80_crt, , config_z80_public.inc:668
OTERM_MSG_BELL                  = $0024 ; const, public, , z80_crt, , config_z80_public.inc:669
OTERM_MSG_PSCROLL               = $0025 ; const, public, , z80_crt, , config_z80_public.inc:670
__MESSAGE_OTERM_NEXT__          = $0026 ; const, public, , z80_crt, , config_z80_public.inc:672
ICHAR_MSG_GETC                  = $000F ; const, public, , z80_crt, , config_z80_public.inc:674
OCHAR_MSG_PUTC_BIN              = $001E ; const, public, , z80_crt, , config_z80_public.inc:675
OCHAR_MSG_PUTC                  = $0020 ; const, public, , z80_crt, , config_z80_public.inc:676
__MESSAGE_NEXT__                = $002D ; const, public, , z80_crt, , config_z80_public.inc:678
mtx_plain                       = $0001 ; const, public, , z80_crt, , config_z80_public.inc:680
mtx_recursive                   = $0002 ; const, public, , z80_crt, , config_z80_public.inc:681
mtx_timed                       = $0004 ; const, public, , z80_crt, , config_z80_public.inc:682
thrd_success                    = $0000 ; const, public, , z80_crt, , config_z80_public.inc:684
thrd_error                      = $0001 ; const, public, , z80_crt, , config_z80_public.inc:685
thrd_nomem                      = $0002 ; const, public, , z80_crt, , config_z80_public.inc:686
thrd_busy                       = $0004 ; const, public, , z80_crt, , config_z80_public.inc:687
thrd_timedout                   = $0008 ; const, public, , z80_crt, , config_z80_public.inc:688
IOCTL_RESET                     = $0000 ; const, public, , z80_crt, , config_z80_public.inc:690
IOCTL_ITERM_ECHO                = $C081 ; const, public, , z80_crt, , config_z80_public.inc:692
IOCTL_ITERM_PASS                = $C041 ; const, public, , z80_crt, , config_z80_public.inc:693
IOCTL_ITERM_LINE                = $C021 ; const, public, , z80_crt, , config_z80_public.inc:694
IOCTL_ITERM_COOK                = $C011 ; const, public, , z80_crt, , config_z80_public.inc:695
IOCTL_ITERM_CAPS                = $C009 ; const, public, , z80_crt, , config_z80_public.inc:696
IOCTL_ITERM_CRLF                = $C101 ; const, public, , z80_crt, , config_z80_public.inc:697
IOCTL_ITERM_CURS                = $C201 ; const, public, , z80_crt, , config_z80_public.inc:698
IOCTL_ITERM_TIE                 = $0201 ; const, public, , z80_crt, , config_z80_public.inc:700
IOCTL_ITERM_GET_EDITBUF         = $0381 ; const, public, , z80_crt, , config_z80_public.inc:701
IOCTL_ITERM_SET_EDITBUF         = $0301 ; const, public, , z80_crt, , config_z80_public.inc:702
IOCTL_OTERM_PAGE                = $C082 ; const, public, , z80_crt, , config_z80_public.inc:704
IOCTL_OTERM_PAUSE               = $C042 ; const, public, , z80_crt, , config_z80_public.inc:705
IOCTL_OTERM_COOK                = $C022 ; const, public, , z80_crt, , config_z80_public.inc:706
IOCTL_OTERM_CRLF                = $C012 ; const, public, , z80_crt, , config_z80_public.inc:707
IOCTL_OTERM_CLEAR               = $E002 ; const, public, , z80_crt, , config_z80_public.inc:708
IOCTL_OTERM_SIGNAL              = $C202 ; const, public, , z80_crt, , config_z80_public.inc:709
IOCTL_OTERM_BELL                = $C102 ; const, public, , z80_crt, , config_z80_public.inc:710
IOCTL_OTERM_CLS                 = $0102 ; const, public, , z80_crt, , config_z80_public.inc:712
IOCTL_OTERM_RESET_SCROLL        = $0202 ; const, public, , z80_crt, , config_z80_public.inc:713
IOCTL_OTERM_GET_WINDOW_COORD    = $0382 ; const, public, , z80_crt, , config_z80_public.inc:714
IOCTL_OTERM_SET_WINDOW_COORD    = $0302 ; const, public, , z80_crt, , config_z80_public.inc:715
IOCTL_OTERM_GET_WINDOW_RECT     = $0482 ; const, public, , z80_crt, , config_z80_public.inc:716
IOCTL_OTERM_SET_WINDOW_RECT     = $0402 ; const, public, , z80_crt, , config_z80_public.inc:717
IOCTL_OTERM_GET_CURSOR_COORD    = $0582 ; const, public, , z80_crt, , config_z80_public.inc:718
IOCTL_OTERM_SET_CURSOR_COORD    = $0502 ; const, public, , z80_crt, , config_z80_public.inc:719
IOCTL_OTERM_GET_OTERM           = $0602 ; const, public, , z80_crt, , config_z80_public.inc:720
IOCTL_OTERM_SCROLL              = $0702 ; const, public, , z80_crt, , config_z80_public.inc:721
IOCTL_OTERM_FONT                = $0802 ; const, public, , z80_crt, , config_z80_public.inc:722
IOCTL_OTERM_FZX_GET_PAPER_COORD = $0A82 ; const, public, , z80_crt, , config_z80_public.inc:724
IOCTL_OTERM_FZX_SET_PAPER_COORD = $0A02 ; const, public, , z80_crt, , config_z80_public.inc:725
IOCTL_OTERM_FZX_GET_PAPER_RECT  = $0B82 ; const, public, , z80_crt, , config_z80_public.inc:726
IOCTL_OTERM_FZX_SET_PAPER_RECT  = $0B02 ; const, public, , z80_crt, , config_z80_public.inc:727
IOCTL_OTERM_FZX_LEFT_MARGIN     = $0C02 ; const, public, , z80_crt, , config_z80_public.inc:728
IOCTL_OTERM_FZX_LINE_SPACING    = $0D02 ; const, public, , z80_crt, , config_z80_public.inc:729
IOCTL_OTERM_FZX_SPACE_EXPAND    = $0E02 ; const, public, , z80_crt, , config_z80_public.inc:730
IOCTL_OTERM_FZX_GET_FZX_STATE   = $0F82 ; const, public, , z80_crt, , config_z80_public.inc:731
IOCTL_OTERM_FZX_SET_FZX_STATE   = $0F02 ; const, public, , z80_crt, , config_z80_public.inc:732
IOCTL_ICHAR_CRLF                = $C103 ; const, public, , z80_crt, , config_z80_public.inc:734
IOCTL_OCHAR_CRLF                = $C014 ; const, public, , z80_crt, , config_z80_public.inc:736
__clib_fopen_max                = $0000 ; const, public, , z80_crt, , z80_crt.asm:507
__clib_open_max                 = $0000 ; const, public, , z80_crt, , z80_crt.asm:526
__exit_stack_size               = $0000 ; const, public, , z80_crt, , z80_crt.asm:608
__quickexit_stack_size          = $0000 ; const, public, , z80_crt, , z80_crt.asm:609
__MAX_FOPEN                     = $0000 ; const, public, , z80_crt, data_stdio, z80_crt.asm:789
__stdio_open_file_list          = $808B ; addr, public, , z80_crt, bss_stdio, z80_crt.asm:797
__stdio_closed_file_list        = $8004 ; addr, public, , z80_crt, data_stdio, z80_crt.asm:803
__fcntl_fdtbl                   = $0000 ; const, public, , z80_crt, data_stdio, z80_crt.asm:861
__fcntl_fdtbl_size              = $0000 ; const, public, , z80_crt, data_stdio, z80_crt.asm:865
__MAX_OPEN                      = $0000 ; const, public, , z80_crt, data_stdio, z80_crt.asm:870
__stdio_heap                    = $8002 ; addr, public, , z80_crt, data_fcntl, z80_crt.asm:942
__stdio_block                   = $800B ; addr, public, , z80_crt, bss_fcntl, z80_crt.asm:949
__Start                         = $0069 ; addr, public, , z80_crt, CODE, z80_crt.asm:999
__Exit                          = $00B2 ; addr, public, , z80_crt, code_crt_main, z80_crt.asm:1055
_z80_rst_08h_vector             = $0009 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:33
_z80_rst_10h_vector             = $0011 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:65
_z80_rst_18h_vector             = $0019 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:97
l_dec_de                        = $001E ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:107
_z80_rst_20h_vector             = $0021 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:137
l_dec_bc                        = $0026 ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:147
_z80_rst_28h_vector             = $0029 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:177
l_ret                           = $002E ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:187
_z80_rst_30h_vector             = $0031 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:217
l_jpix                          = $0033 ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:225
l_jphl                          = $0034 ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:231
l_jpiy                          = $0035 ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:237
_z80_rst_38h_vector             = $0039 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:291
l_setmem_hl                     = $005B ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:333
l_inc_hl                        = $0064 ; addr, public, , z80_crt, CODE, crt_page_zero_z80.inc:351
_z80_nmi_vector                 = $0067 ; const, public, , z80_crt, CODE, crt_page_zero_z80.inc:382
__malloc_heap                   = $8000 ; addr, public, , z80_crt, data_alloc_malloc, clib_variables.inc:35
__exit_stack                    = $808D ; addr, public, , z80_crt, bss_stdlib, clib_variables.inc:136
__quickexit_stack               = $808E ; addr, public, , z80_crt, bss_stdlib, clib_variables.inc:146
__thrd_id                       = $8008 ; addr, public, , z80_crt, data_threads, clib_variables.inc:156
__ch_system                     = $0132 ; addr, public, , z80_crt, data_threads, clib_stubs.inc:12
__thread_context_switch         = $002E ; addr, public, , z80_crt, data_threads, clib_stubs.inc:23
__thread_block_timeout          = $002E ; addr, public, , z80_crt, data_threads, clib_stubs.inc:24
__thread_unblock                = $002E ; addr, public, , z80_crt, data_threads, clib_stubs.inc:25
_main                           = $016C ; addr, public, , test_c, code_compiler, test.c:230
_one                            = $0000 ; addr, public, , test1, , test1.asm:4
asm_heap_init                   = $00B8 ; addr, public, , asm_heap_init, code_alloc_malloc, alloc/malloc/z80/asm_heap_init.asm:22
asm_dzx7_standard               = $00DA ; addr, public, , asm_dzx7_standard, code_compress_zx7, compress/zx7/z80/asm_dzx7_standard.asm:22
error_enolck_zc                 = $0124 ; addr, public, , error_enolck_zc, code_error, error/z80/error_enolck_zc.asm:42
errno_zc                        = $0126 ; addr, public, , errno_zc, code_error, error/z80/errno_zc.asm:21
_errno                          = $8009 ; addr, public, , _errno, bss_error, error/z80/_errno.asm:7
error_zc                        = $0132 ; addr, public, , error_zc, code_error, error/z80/error_zc.asm:12
l_ei_reti                       = $0137 ; addr, public, , l_ei_reti, code_l, l/z80/l_ei_reti.asm:7
l_retn                          = $013A ; addr, public, , l_retn, code_l, l/z80/l_retn.asm:7
asm_memset                      = $013C ; addr, public, , asm_memset, code_string, string/z80/asm_memset.asm:19
asm_mtx_init                    = $014D ; addr, public, , asm_mtx_init, code_threads_mutex, threads/mutex/z80/asm_mtx_init.asm:19
__head                          = $0000 ; const, public, def, , ,
__tail                          = $0000 ; const, public, def, , ,
__size                          = $0000 ; const, public, def, , ,
__CODE_head                     = $0000 ; const, public, def, , ,
__CODE_tail                     = $0086 ; const, public, def, , ,
__CODE_size                     = $0086 ; const, public, def, , ,
__code_crt_init_head            = $0086 ; const, public, def, , ,
__code_crt_init_tail            = $00AE ; const, public, def, , ,
__code_crt_init_size            = $0028 ; const, public, def, , ,
__code_crt_main_head            = $00AE ; const, public, def, , ,
__code_crt_main_tail            = $00B3 ; const, public, def, , ,
__code_crt_main_size            = $0005 ; const, public, def, , ,
__code_crt_exit_head            = $00B3 ; const, public, def, , ,
__code_crt_exit_tail            = $00B3 ; const, public, def, , ,
__code_crt_exit_size            = $0000 ; const, public, def, , ,
__code_crt_return_head          = $00B3 ; const, public, def, , ,
__code_crt_return_tail          = $00B8 ; const, public, def, , ,
__code_crt_return_size          = $0005 ; const, public, def, , ,
__code_crt_common_head          = $00B8 ; const, public, def, , ,
__code_crt_common_tail          = $00B8 ; const, public, def, , ,
__code_crt_common_size          = $0000 ; const, public, def, , ,
__code_driver_head              = $00B8 ; const, public, def, , ,
__code_driver_tail              = $00B8 ; const, public, def, , ,
__code_driver_size              = $0000 ; const, public, def, , ,
__code_font_head                = $00B8 ; const, public, def, , ,
__code_font_tail                = $00B8 ; const, public, def, , ,
__code_font_size                = $0000 ; const, public, def, , ,
__code_clib_head                = $00B8 ; const, public, def, , ,
__code_clib_tail                = $00B8 ; const, public, def, , ,
__code_clib_size                = $0000 ; const, public, def, , ,
__code_adt_b_array_head         = $00B8 ; const, public, def, , ,
__code_adt_b_array_tail         = $00B8 ; const, public, def, , ,
__code_adt_b_array_size         = $0000 ; const, public, def, , ,
__code_adt_b_vector_head        = $00B8 ; const, public, def, , ,
__code_adt_b_vector_tail        = $00B8 ; const, public, def, , ,
__code_adt_b_vector_size        = $0000 ; const, public, def, , ,
__code_adt_ba_priority_queue_head = $00B8 ; const, public, def, , ,
__code_adt_ba_priority_queue_tail = $00B8 ; const, public, def, , ,
__code_adt_ba_priority_queue_size = $0000 ; const, public, def, , ,
__code_adt_ba_stack_head        = $00B8 ; const, public, def, , ,
__code_adt_ba_stack_tail        = $00B8 ; const, public, def, , ,
__code_adt_ba_stack_size        = $0000 ; const, public, def, , ,
__code_adt_bv_priority_queue_head = $00B8 ; const, public, def, , ,
__code_adt_bv_priority_queue_tail = $00B8 ; const, public, def, , ,
__code_adt_bv_priority_queue_size = $0000 ; const, public, def, , ,
__code_adt_bv_stack_head        = $00B8 ; const, public, def, , ,
__code_adt_bv_stack_tail        = $00B8 ; const, public, def, , ,
__code_adt_bv_stack_size        = $0000 ; const, public, def, , ,
__code_adt_p_forward_list_head  = $00B8 ; const, public, def, , ,
__code_adt_p_forward_list_tail  = $00B8 ; const, public, def, , ,
__code_adt_p_forward_list_size  = $0000 ; const, public, def, , ,
__code_adt_p_forward_list_alt_head = $00B8 ; const, public, def, , ,
__code_adt_p_forward_list_alt_tail = $00B8 ; const, public, def, , ,
__code_adt_p_forward_list_alt_size = $0000 ; const, public, def, , ,
__code_adt_p_list_head          = $00B8 ; const, public, def, , ,
__code_adt_p_list_tail          = $00B8 ; const, public, def, , ,
__code_adt_p_list_size          = $0000 ; const, public, def, , ,
__code_adt_p_queue_head         = $00B8 ; const, public, def, , ,
__code_adt_p_queue_tail         = $00B8 ; const, public, def, , ,
__code_adt_p_queue_size         = $0000 ; const, public, def, , ,
__code_adt_p_stack_head         = $00B8 ; const, public, def, , ,
__code_adt_p_stack_tail         = $00B8 ; const, public, def, , ,
__code_adt_p_stack_size         = $0000 ; const, public, def, , ,
__code_adt_w_array_head         = $00B8 ; const, public, def, , ,
__code_adt_w_array_tail         = $00B8 ; const, public, def, , ,
__code_adt_w_array_size         = $0000 ; const, public, def, , ,
__code_adt_w_vector_head        = $00B8 ; const, public, def, , ,
__code_adt_w_vector_tail        = $00B8 ; const, public, def, , ,
__code_adt_w_vector_size        = $0000 ; const, public, def, , ,
__code_adt_wa_priority_queue_head = $00B8 ; const, public, def, , ,
__code_adt_wa_priority_queue_tail = $00B8 ; const, public, def, , ,
__code_adt_wa_priority_queue_size = $0000 ; const, public, def, , ,
__code_adt_wa_stack_head        = $00B8 ; const, public, def, , ,
__code_adt_wa_stack_tail        = $00B8 ; const, public, def, , ,
__code_adt_wa_stack_size        = $0000 ; const, public, def, , ,
__code_adt_wv_priority_queue_head = $00B8 ; const, public, def, , ,
__code_adt_wv_priority_queue_tail = $00B8 ; const, public, def, , ,
__code_adt_wv_priority_queue_size = $0000 ; const, public, def, , ,
__code_adt_wv_stack_head        = $00B8 ; const, public, def, , ,
__code_adt_wv_stack_tail        = $00B8 ; const, public, def, , ,
__code_adt_wv_stack_size        = $0000 ; const, public, def, , ,
__code_alloc_balloc_head        = $00B8 ; const, public, def, , ,
__code_alloc_balloc_tail        = $00B8 ; const, public, def, , ,
__code_alloc_balloc_size        = $0000 ; const, public, def, , ,
__code_alloc_malloc_head        = $00B8 ; const, public, def, , ,
__code_alloc_malloc_tail        = $00DA ; const, public, def, , ,
__code_alloc_malloc_size        = $0022 ; const, public, def, , ,
__code_alloc_obstack_head       = $00DA ; const, public, def, , ,
__code_alloc_obstack_tail       = $00DA ; const, public, def, , ,
__code_alloc_obstack_size       = $0000 ; const, public, def, , ,
__code_arch_head                = $00DA ; const, public, def, , ,
__code_arch_tail                = $00DA ; const, public, def, , ,
__code_arch_size                = $0000 ; const, public, def, , ,
__code_bifrost_h_head           = $00DA ; const, public, def, , ,
__code_bifrost_h_tail           = $00DA ; const, public, def, , ,
__code_bifrost_h_size           = $0000 ; const, public, def, , ,
__code_bifrost_l_head           = $00DA ; const, public, def, , ,
__code_bifrost_l_tail           = $00DA ; const, public, def, , ,
__code_bifrost_l_size           = $0000 ; const, public, def, , ,
__code_bifrost2_head            = $00DA ; const, public, def, , ,
__code_bifrost2_tail            = $00DA ; const, public, def, , ,
__code_bifrost2_size            = $0000 ; const, public, def, , ,
__code_compress_aplib_head      = $00DA ; const, public, def, , ,
__code_compress_aplib_tail      = $00DA ; const, public, def, , ,
__code_compress_aplib_size      = $0000 ; const, public, def, , ,
__code_compress_zx7_head        = $00DA ; const, public, def, , ,
__code_compress_zx7_tail        = $0121 ; const, public, def, , ,
__code_compress_zx7_size        = $0047 ; const, public, def, , ,
__code_ctype_head               = $0121 ; const, public, def, , ,
__code_ctype_tail               = $0121 ; const, public, def, , ,
__code_ctype_size               = $0000 ; const, public, def, , ,
__code_driver_general_head      = $0121 ; const, public, def, , ,
__code_driver_general_tail      = $0121 ; const, public, def, , ,
__code_driver_general_size      = $0000 ; const, public, def, , ,
__code_driver_character_input_head = $0121 ; const, public, def, , ,
__code_driver_character_input_tail = $0121 ; const, public, def, , ,
__code_driver_character_input_size = $0000 ; const, public, def, , ,
__code_driver_character_output_head = $0121 ; const, public, def, , ,
__code_driver_character_output_tail = $0121 ; const, public, def, , ,
__code_driver_character_output_size = $0000 ; const, public, def, , ,
__code_driver_memstream_head    = $0121 ; const, public, def, , ,
__code_driver_memstream_tail    = $0121 ; const, public, def, , ,
__code_driver_memstream_size    = $0000 ; const, public, def, , ,
__code_driver_terminal_input_head = $0121 ; const, public, def, , ,
__code_driver_terminal_input_tail = $0121 ; const, public, def, , ,
__code_driver_terminal_input_size = $0000 ; const, public, def, , ,
__code_driver_terminal_output_head = $0121 ; const, public, def, , ,
__code_driver_terminal_output_tail = $0121 ; const, public, def, , ,
__code_driver_terminal_output_size = $0000 ; const, public, def, , ,
__code_driver_tty_head          = $0121 ; const, public, def, , ,
__code_driver_tty_tail          = $0121 ; const, public, def, , ,
__code_driver_tty_size          = $0000 ; const, public, def, , ,
__code_error_head               = $0121 ; const, public, def, , ,
__code_error_tail               = $0137 ; const, public, def, , ,
__code_error_size               = $0016 ; const, public, def, , ,
__code_esxdos_head              = $0137 ; const, public, def, , ,
__code_esxdos_tail              = $0137 ; const, public, def, , ,
__code_esxdos_size              = $0000 ; const, public, def, , ,
__code_fcntl_head               = $0137 ; const, public, def, , ,
__code_fcntl_tail               = $0137 ; const, public, def, , ,
__code_fcntl_size               = $0000 ; const, public, def, , ,
__code_font_fzx_head            = $0137 ; const, public, def, , ,
__code_font_fzx_tail            = $0137 ; const, public, def, , ,
__code_font_fzx_size            = $0000 ; const, public, def, , ,
__code_fp_genmath_head          = $0137 ; const, public, def, , ,
__code_fp_genmath_tail          = $0137 ; const, public, def, , ,
__code_fp_genmath_size          = $0000 ; const, public, def, , ,
__code_fp_math48_head           = $0137 ; const, public, def, , ,
__code_fp_math48_tail           = $0137 ; const, public, def, , ,
__code_fp_math48_size           = $0000 ; const, public, def, , ,
__code_im2_head                 = $0137 ; const, public, def, , ,
__code_im2_tail                 = $0137 ; const, public, def, , ,
__code_im2_size                 = $0000 ; const, public, def, , ,
__code_input_head               = $0137 ; const, public, def, , ,
__code_input_tail               = $0137 ; const, public, def, , ,
__code_input_size               = $0000 ; const, public, def, , ,
__code_inttypes_head            = $0137 ; const, public, def, , ,
__code_inttypes_tail            = $0137 ; const, public, def, , ,
__code_inttypes_size            = $0000 ; const, public, def, , ,
__code_l_head                   = $0137 ; const, public, def, , ,
__code_l_tail                   = $013C ; const, public, def, , ,
__code_l_size                   = $0005 ; const, public, def, , ,
__code_l_sccz80_head            = $013C ; const, public, def, , ,
__code_l_sccz80_tail            = $013C ; const, public, def, , ,
__code_l_sccz80_size            = $0000 ; const, public, def, , ,
__code_l_sdcc_head              = $013C ; const, public, def, , ,
__code_l_sdcc_tail              = $013C ; const, public, def, , ,
__code_l_sdcc_size              = $0000 ; const, public, def, , ,
__code_locale_head              = $013C ; const, public, def, , ,
__code_locale_tail              = $013C ; const, public, def, , ,
__code_locale_size              = $0000 ; const, public, def, , ,
__code_math_head                = $013C ; const, public, def, , ,
__code_math_tail                = $013C ; const, public, def, , ,
__code_math_size                = $0000 ; const, public, def, , ,
__code_network_head             = $013C ; const, public, def, , ,
__code_network_tail             = $013C ; const, public, def, , ,
__code_network_size             = $0000 ; const, public, def, , ,
__code_nirvanam_head            = $013C ; const, public, def, , ,
__code_nirvanam_tail            = $013C ; const, public, def, , ,
__code_nirvanam_size            = $0000 ; const, public, def, , ,
__code_nirvanap_head            = $013C ; const, public, def, , ,
__code_nirvanap_tail            = $013C ; const, public, def, , ,
__code_nirvanap_size            = $0000 ; const, public, def, , ,
__code_PSGlib_head              = $013C ; const, public, def, , ,
__code_PSGlib_tail              = $013C ; const, public, def, , ,
__code_PSGlib_size              = $0000 ; const, public, def, , ,
__code_setjmp_head              = $013C ; const, public, def, , ,
__code_setjmp_tail              = $013C ; const, public, def, , ,
__code_setjmp_size              = $0000 ; const, public, def, , ,
__code_SMSlib_head              = $013C ; const, public, def, , ,
__code_SMSlib_tail              = $013C ; const, public, def, , ,
__code_SMSlib_size              = $0000 ; const, public, def, , ,
__code_sound_bit_head           = $013C ; const, public, def, , ,
__code_sound_bit_tail           = $013C ; const, public, def, , ,
__code_sound_bit_size           = $0000 ; const, public, def, , ,
__code_stdio_head               = $013C ; const, public, def, , ,
__code_stdio_tail               = $013C ; const, public, def, , ,
__code_stdio_size               = $0000 ; const, public, def, , ,
__code_stdlib_head              = $013C ; const, public, def, , ,
__code_stdlib_tail              = $013C ; const, public, def, , ,
__code_stdlib_size              = $0000 ; const, public, def, , ,
__code_string_head              = $013C ; const, public, def, , ,
__code_string_tail              = $014D ; const, public, def, , ,
__code_string_size              = $0011 ; const, public, def, , ,
__code_temp_sp1_head            = $014D ; const, public, def, , ,
__code_temp_sp1_tail            = $014D ; const, public, def, , ,
__code_temp_sp1_size            = $0000 ; const, public, def, , ,
__code_threads_head             = $014D ; const, public, def, , ,
__code_threads_tail             = $014D ; const, public, def, , ,
__code_threads_size             = $0000 ; const, public, def, , ,
__code_threads_mutex_head       = $014D ; const, public, def, , ,
__code_threads_mutex_tail       = $016C ; const, public, def, , ,
__code_threads_mutex_size       = $001F ; const, public, def, , ,
__code_z180_head                = $016C ; const, public, def, , ,
__code_z180_tail                = $016C ; const, public, def, , ,
__code_z180_size                = $0000 ; const, public, def, , ,
__code_z80_head                 = $016C ; const, public, def, , ,
__code_z80_tail                 = $016C ; const, public, def, , ,
__code_z80_size                 = $0000 ; const, public, def, , ,
__code_lib_head                 = $016C ; const, public, def, , ,
__code_lib_tail                 = $016C ; const, public, def, , ,
__code_lib_size                 = $0000 ; const, public, def, , ,
__code_compiler_head            = $016C ; const, public, def, , ,
__code_compiler_tail            = $0177 ; const, public, def, , ,
__code_compiler_size            = $000B ; const, public, def, , ,
__code_user_head                = $0177 ; const, public, def, , ,
__code_user_tail                = $0177 ; const, public, def, , ,
__code_user_size                = $0000 ; const, public, def, , ,
__rodata_driver_head            = $0177 ; const, public, def, , ,
__rodata_driver_tail            = $0177 ; const, public, def, , ,
__rodata_driver_size            = $0000 ; const, public, def, , ,
__rodata_font_head              = $0177 ; const, public, def, , ,
__rodata_font_tail              = $0177 ; const, public, def, , ,
__rodata_font_size              = $0000 ; const, public, def, , ,
__rodata_clib_head              = $0177 ; const, public, def, , ,
__rodata_clib_tail              = $0177 ; const, public, def, , ,
__rodata_clib_size              = $0000 ; const, public, def, , ,
__rodata_arch_head              = $0177 ; const, public, def, , ,
__rodata_arch_tail              = $0177 ; const, public, def, , ,
__rodata_arch_size              = $0000 ; const, public, def, , ,
__rodata_error_strings_head     = $0177 ; const, public, def, , ,
__rodata_error_strings_tail     = $0177 ; const, public, def, , ,
__rodata_error_strings_size     = $0000 ; const, public, def, , ,
__rodata_error_string_end_head  = $0177 ; const, public, def, , ,
__rodata_error_string_end_tail  = $0178 ; const, public, def, , ,
__rodata_error_string_end_size  = $0001 ; const, public, def, , ,
__rodata_fcntl_head             = $0178 ; const, public, def, , ,
__rodata_fcntl_tail             = $0178 ; const, public, def, , ,
__rodata_fcntl_size             = $0000 ; const, public, def, , ,
__rodata_font_4x8_head          = $0178 ; const, public, def, , ,
__rodata_font_4x8_tail          = $0178 ; const, public, def, , ,
__rodata_font_4x8_size          = $0000 ; const, public, def, , ,
__rodata_font_8x8_head          = $0178 ; const, public, def, , ,
__rodata_font_8x8_tail          = $0178 ; const, public, def, , ,
__rodata_font_8x8_size          = $0000 ; const, public, def, , ,
__rodata_font_fzx_head          = $0178 ; const, public, def, , ,
__rodata_font_fzx_tail          = $0178 ; const, public, def, , ,
__rodata_font_fzx_size          = $0000 ; const, public, def, , ,
__rodata_input_head             = $0178 ; const, public, def, , ,
__rodata_input_tail             = $0178 ; const, public, def, , ,
__rodata_input_size             = $0000 ; const, public, def, , ,
__rodata_SMSlib_head            = $0178 ; const, public, def, , ,
__rodata_SMSlib_tail            = $0178 ; const, public, def, , ,
__rodata_SMSlib_size            = $0000 ; const, public, def, , ,
__rodata_sound_bit_head         = $0178 ; const, public, def, , ,
__rodata_sound_bit_tail         = $0178 ; const, public, def, , ,
__rodata_sound_bit_size         = $0000 ; const, public, def, , ,
__rodata_stdio_head             = $0178 ; const, public, def, , ,
__rodata_stdio_tail             = $0178 ; const, public, def, , ,
__rodata_stdio_size             = $0000 ; const, public, def, , ,
__rodata_stdlib_head            = $0178 ; const, public, def, , ,
__rodata_stdlib_tail            = $0178 ; const, public, def, , ,
__rodata_stdlib_size            = $0000 ; const, public, def, , ,
__rodata_lib_head               = $0178 ; const, public, def, , ,
__rodata_lib_tail               = $0178 ; const, public, def, , ,
__rodata_lib_size               = $0000 ; const, public, def, , ,
__rodata_compiler_head          = $0178 ; const, public, def, , ,
__rodata_compiler_tail          = $0178 ; const, public, def, , ,
__rodata_compiler_size          = $0000 ; const, public, def, , ,
__rodata_user_head              = $0178 ; const, public, def, , ,
__rodata_user_tail              = $0178 ; const, public, def, , ,
__rodata_user_size              = $0000 ; const, public, def, , ,
__CODE_END_head                 = $0178 ; const, public, def, , ,
__CODE_END_tail                 = $0178 ; const, public, def, , ,
__CODE_END_size                 = $0000 ; const, public, def, , ,
__DATA_head                     = $8000 ; const, public, def, , ,
__DATA_tail                     = $8000 ; const, public, def, , ,
__DATA_size                     = $0000 ; const, public, def, , ,
__data_align_256_head           = $8000 ; const, public, def, , ,
__data_align_256_tail           = $8000 ; const, public, def, , ,
__data_align_256_size           = $0000 ; const, public, def, , ,
__data_align_128_head           = $8000 ; const, public, def, , ,
__data_align_128_tail           = $8000 ; const, public, def, , ,
__data_align_128_size           = $0000 ; const, public, def, , ,
__data_align_64_head            = $8000 ; const, public, def, , ,
__data_align_64_tail            = $8000 ; const, public, def, , ,
__data_align_64_size            = $0000 ; const, public, def, , ,
__data_align_32_head            = $8000 ; const, public, def, , ,
__data_align_32_tail            = $8000 ; const, public, def, , ,
__data_align_32_size            = $0000 ; const, public, def, , ,
__data_align_16_head            = $8000 ; const, public, def, , ,
__data_align_16_tail            = $8000 ; const, public, def, , ,
__data_align_16_size            = $0000 ; const, public, def, , ,
__data_align_8_head             = $8000 ; const, public, def, , ,
__data_align_8_tail             = $8000 ; const, public, def, , ,
__data_align_8_size             = $0000 ; const, public, def, , ,
__data_align_4_head             = $8000 ; const, public, def, , ,
__data_align_4_tail             = $8000 ; const, public, def, , ,
__data_align_4_size             = $0000 ; const, public, def, , ,
__data_align_2_head             = $8000 ; const, public, def, , ,
__data_align_2_tail             = $8000 ; const, public, def, , ,
__data_align_2_size             = $0000 ; const, public, def, , ,
__smc_jump_vectors_head         = $8000 ; const, public, def, , ,
__smc_jump_vectors_tail         = $8000 ; const, public, def, , ,
__smc_jump_vectors_size         = $0000 ; const, public, def, , ,
__smc_driver_head               = $8000 ; const, public, def, , ,
__smc_driver_tail               = $8000 ; const, public, def, , ,
__smc_driver_size               = $0000 ; const, public, def, , ,
__smc_font_head                 = $8000 ; const, public, def, , ,
__smc_font_tail                 = $8000 ; const, public, def, , ,
__smc_font_size                 = $0000 ; const, public, def, , ,
__smc_clib_head                 = $8000 ; const, public, def, , ,
__smc_clib_tail                 = $8000 ; const, public, def, , ,
__smc_clib_size                 = $0000 ; const, public, def, , ,
__smc_fcntl_head                = $8000 ; const, public, def, , ,
__smc_fcntl_tail                = $8000 ; const, public, def, , ,
__smc_fcntl_size                = $0000 ; const, public, def, , ,
__smc_l_head                    = $8000 ; const, public, def, , ,
__smc_l_tail                    = $8000 ; const, public, def, , ,
__smc_l_size                    = $0000 ; const, public, def, , ,
__smc_sound_bit_head            = $8000 ; const, public, def, , ,
__smc_sound_bit_tail            = $8000 ; const, public, def, , ,
__smc_sound_bit_size            = $0000 ; const, public, def, , ,
__smc_lib_head                  = $8000 ; const, public, def, , ,
__smc_lib_tail                  = $8000 ; const, public, def, , ,
__smc_lib_size                  = $0000 ; const, public, def, , ,
__smc_compiler_head             = $8000 ; const, public, def, , ,
__smc_compiler_tail             = $8000 ; const, public, def, , ,
__smc_compiler_size             = $0000 ; const, public, def, , ,
__smc_user_head                 = $8000 ; const, public, def, , ,
__smc_user_tail                 = $8000 ; const, public, def, , ,
__smc_user_size                 = $0000 ; const, public, def, , ,
__data_driver_head              = $8000 ; const, public, def, , ,
__data_driver_tail              = $8000 ; const, public, def, , ,
__data_driver_size              = $0000 ; const, public, def, , ,
__data_font_head                = $8000 ; const, public, def, , ,
__data_font_tail                = $8000 ; const, public, def, , ,
__data_font_size                = $0000 ; const, public, def, , ,
__data_clib_head                = $8000 ; const, public, def, , ,
__data_clib_tail                = $8000 ; const, public, def, , ,
__data_clib_size                = $0000 ; const, public, def, , ,
__data_alloc_balloc_head        = $8000 ; const, public, def, , ,
__data_alloc_balloc_tail        = $8000 ; const, public, def, , ,
__data_alloc_balloc_size        = $0000 ; const, public, def, , ,
__data_alloc_malloc_head        = $8000 ; const, public, def, , ,
__data_alloc_malloc_tail        = $8002 ; const, public, def, , ,
__data_alloc_malloc_size        = $0002 ; const, public, def, , ,
__data_arch_head                = $8002 ; const, public, def, , ,
__data_arch_tail                = $8002 ; const, public, def, , ,
__data_arch_size                = $0000 ; const, public, def, , ,
__data_fcntl_head               = $8002 ; const, public, def, , ,
__data_fcntl_tail               = $8004 ; const, public, def, , ,
__data_fcntl_size               = $0002 ; const, public, def, , ,
__data_fcntl_stdio_heap_head_head = $8004 ; const, public, def, , ,
__data_fcntl_stdio_heap_head_tail = $8004 ; const, public, def, , ,
__data_fcntl_stdio_heap_head_size = $0000 ; const, public, def, , ,
__data_fcntl_stdio_heap_body_head = $8004 ; const, public, def, , ,
__data_fcntl_stdio_heap_body_tail = $8004 ; const, public, def, , ,
__data_fcntl_stdio_heap_body_size = $0000 ; const, public, def, , ,
__data_fcntl_stdio_heap_tail_head = $8004 ; const, public, def, , ,
__data_fcntl_stdio_heap_tail_tail = $8004 ; const, public, def, , ,
__data_fcntl_stdio_heap_tail_size = $0000 ; const, public, def, , ,
__data_fcntl_fdtable_body_head  = $8004 ; const, public, def, , ,
__data_fcntl_fdtable_body_tail  = $8004 ; const, public, def, , ,
__data_fcntl_fdtable_body_size  = $0000 ; const, public, def, , ,
__data_PSGlib_head              = $8004 ; const, public, def, , ,
__data_PSGlib_tail              = $8004 ; const, public, def, , ,
__data_PSGlib_size              = $0000 ; const, public, def, , ,
__data_SMSlib_head              = $8004 ; const, public, def, , ,
__data_SMSlib_tail              = $8004 ; const, public, def, , ,
__data_SMSlib_size              = $0000 ; const, public, def, , ,
__data_sound_bit_head           = $8004 ; const, public, def, , ,
__data_sound_bit_tail           = $8004 ; const, public, def, , ,
__data_sound_bit_size           = $0000 ; const, public, def, , ,
__data_stdio_head               = $8004 ; const, public, def, , ,
__data_stdio_tail               = $8008 ; const, public, def, , ,
__data_stdio_size               = $0004 ; const, public, def, , ,
__data_stdlib_head              = $8008 ; const, public, def, , ,
__data_stdlib_tail              = $8008 ; const, public, def, , ,
__data_stdlib_size              = $0000 ; const, public, def, , ,
__data_threads_head             = $8008 ; const, public, def, , ,
__data_threads_tail             = $8009 ; const, public, def, , ,
__data_threads_size             = $0001 ; const, public, def, , ,
__data_lib_head                 = $8009 ; const, public, def, , ,
__data_lib_tail                 = $8009 ; const, public, def, , ,
__data_lib_size                 = $0000 ; const, public, def, , ,
__data_compiler_head            = $8009 ; const, public, def, , ,
__data_compiler_tail            = $8009 ; const, public, def, , ,
__data_compiler_size            = $0000 ; const, public, def, , ,
__data_user_head                = $8009 ; const, public, def, , ,
__data_user_tail                = $8009 ; const, public, def, , ,
__data_user_size                = $0000 ; const, public, def, , ,
__DATA_END_head                 = $8009 ; const, public, def, , ,
__DATA_END_tail                 = $8009 ; const, public, def, , ,
__DATA_END_size                 = $0000 ; const, public, def, , ,
__BSS_head                      = $8009 ; const, public, def, , ,
__BSS_tail                      = $8009 ; const, public, def, , ,
__BSS_size                      = $0000 ; const, public, def, , ,
__bss_align_256_head            = $8009 ; const, public, def, , ,
__bss_align_256_tail            = $8009 ; const, public, def, , ,
__bss_align_256_size            = $0000 ; const, public, def, , ,
__bss_align_128_head            = $8009 ; const, public, def, , ,
__bss_align_128_tail            = $8009 ; const, public, def, , ,
__bss_align_128_size            = $0000 ; const, public, def, , ,
__bss_align_64_head             = $8009 ; const, public, def, , ,
__bss_align_64_tail             = $8009 ; const, public, def, , ,
__bss_align_64_size             = $0000 ; const, public, def, , ,
__bss_align_32_head             = $8009 ; const, public, def, , ,
__bss_align_32_tail             = $8009 ; const, public, def, , ,
__bss_align_32_size             = $0000 ; const, public, def, , ,
__bss_align_16_head             = $8009 ; const, public, def, , ,
__bss_align_16_tail             = $8009 ; const, public, def, , ,
__bss_align_16_size             = $0000 ; const, public, def, , ,
__bss_align_8_head              = $8009 ; const, public, def, , ,
__bss_align_8_tail              = $8009 ; const, public, def, , ,
__bss_align_8_size              = $0000 ; const, public, def, , ,
__bss_align_4_head              = $8009 ; const, public, def, , ,
__bss_align_4_tail              = $8009 ; const, public, def, , ,
__bss_align_4_size              = $0000 ; const, public, def, , ,
__bss_align_2_head              = $8009 ; const, public, def, , ,
__bss_align_2_tail              = $8009 ; const, public, def, , ,
__bss_align_2_size              = $0000 ; const, public, def, , ,
__bss_driver_head               = $8009 ; const, public, def, , ,
__bss_driver_tail               = $8009 ; const, public, def, , ,
__bss_driver_size               = $0000 ; const, public, def, , ,
__bss_font_head                 = $8009 ; const, public, def, , ,
__bss_font_tail                 = $8009 ; const, public, def, , ,
__bss_font_size                 = $0000 ; const, public, def, , ,
__bss_clib_head                 = $8009 ; const, public, def, , ,
__bss_clib_tail                 = $8009 ; const, public, def, , ,
__bss_clib_size                 = $0000 ; const, public, def, , ,
__bss_arch_head                 = $8009 ; const, public, def, , ,
__bss_arch_tail                 = $8009 ; const, public, def, , ,
__bss_arch_size                 = $0000 ; const, public, def, , ,
__bss_alloc_balloc_head         = $8009 ; const, public, def, , ,
__bss_alloc_balloc_tail         = $8009 ; const, public, def, , ,
__bss_alloc_balloc_size         = $0000 ; const, public, def, , ,
__bss_alloc_malloc_head         = $8009 ; const, public, def, , ,
__bss_alloc_malloc_tail         = $8009 ; const, public, def, , ,
__bss_alloc_malloc_size         = $0000 ; const, public, def, , ,
__bss_compress_aplib_head       = $8009 ; const, public, def, , ,
__bss_compress_aplib_tail       = $8009 ; const, public, def, , ,
__bss_compress_aplib_size       = $0000 ; const, public, def, , ,
__bss_error_head                = $8009 ; const, public, def, , ,
__bss_error_tail                = $800B ; const, public, def, , ,
__bss_error_size                = $0002 ; const, public, def, , ,
__bss_fcntl_head                = $800B ; const, public, def, , ,
__bss_fcntl_tail                = $808B ; const, public, def, , ,
__bss_fcntl_size                = $0080 ; const, public, def, , ,
__bss_input_head                = $808B ; const, public, def, , ,
__bss_input_tail                = $808B ; const, public, def, , ,
__bss_input_size                = $0000 ; const, public, def, , ,
__bss_PSGlib_head               = $808B ; const, public, def, , ,
__bss_PSGlib_tail               = $808B ; const, public, def, , ,
__bss_PSGlib_size               = $0000 ; const, public, def, , ,
__bss_SMSlib_head               = $808B ; const, public, def, , ,
__bss_SMSlib_tail               = $808B ; const, public, def, , ,
__bss_SMSlib_size               = $0000 ; const, public, def, , ,
__bss_sound_bit_head            = $808B ; const, public, def, , ,
__bss_sound_bit_tail            = $808B ; const, public, def, , ,
__bss_sound_bit_size            = $0000 ; const, public, def, , ,
__bss_stdio_head                = $808B ; const, public, def, , ,
__bss_stdio_tail                = $808D ; const, public, def, , ,
__bss_stdio_size                = $0002 ; const, public, def, , ,
__bss_stdlib_head               = $808D ; const, public, def, , ,
__bss_stdlib_tail               = $808F ; const, public, def, , ,
__bss_stdlib_size               = $0002 ; const, public, def, , ,
__bss_string_head               = $808F ; const, public, def, , ,
__bss_string_tail               = $808F ; const, public, def, , ,
__bss_string_size               = $0000 ; const, public, def, , ,
__bss_lib_head                  = $808F ; const, public, def, , ,
__bss_lib_tail                  = $808F ; const, public, def, , ,
__bss_lib_size                  = $0000 ; const, public, def, , ,
__bss_compiler_head             = $808F ; const, public, def, , ,
__bss_compiler_tail             = $808F ; const, public, def, , ,
__bss_compiler_size             = $0000 ; const, public, def, , ,
__bss_user_head                 = $808F ; const, public, def, , ,
__bss_user_tail                 = $808F ; const, public, def, , ,
__bss_user_size                 = $0000 ; const, public, def, , ,
__BSS_UNINITIALIZED_head        = $808F ; const, public, def, , ,
__BSS_UNINITIALIZED_tail        = $808F ; const, public, def, , ,
__BSS_UNINITIALIZED_size        = $0000 ; const, public, def, , ,
__BSS_END_head                  = $808F ; const, public, def, , ,
__BSS_END_tail                  = $808F ; const, public, def, , ,
__BSS_END_size                  = $0000 ; const, public, def, , ,
__interrupt_vectors_head        = $0000 ; const, public, def, , ,
__interrupt_vectors_tail        = $0000 ; const, public, def, , ,
__interrupt_vectors_size        = $0000 ; const, public, def, , ,
__IGNORE_head                   = $0000 ; const, public, def, , ,
__IGNORE_tail                   = $0000 ; const, public, def, , ,
__IGNORE_size                   = $0000 ; const, public, def, , ,
END
}

unlink_testfiles();
done_testing();
